# Exception Propagation Demonstration

## 1) Objective

The purpose of this project is to introduce the concept of **exception propagation** in Java.  
The example shows how exceptions move up the call stack until they are either **handled** by a matching `try-catch` block or cause the program to terminate.

---

## 2) How exception propagation occurs here

- The `Main` class calls a method in `ExceptionScope`.
- Inside `ExceptionScope`, `method3` performs an operation that throws an arithmetic exception.
- Given that does it does **not** handle the exception locally, the exception is **propagated back** to the caller (`method2`), which uses a try-catch statement to deal with the exception.
- The `try-catch` block catches the propagated exception, preventing the program from crashing and printing an error message instead.

This demonstrates that an exception can be thrown in one method but caught and handled in another, higher up in the call stack.

---

## 3) Student exploration

- Move the `try-catch` block **from `method2` into `Main`**.
- Observe the difference in output:
  - When the `try-catch` is in `ExceptionScope`, the exception is handled immediately where it occurs.
  - When the `try-catch` is only in `Main`, the exception travels (propagates) up before being handled.
